/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.httpclient;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.IDeviceMgmt;
import com.tplink.eap.cloudsdk.LogCenter;
import com.tplink.eap.cloudsdk.httpclient.CustomHttpClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiHttpClient
extends CustomHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ApiHttpClient.class);
    private static final String CHARSET_UFT8 = "UTF-8";
    private static final String DEFAULT_SMB_API_HOST = "n-smb-api.tplinkcloud.com";
    private static final String DEFAULT_SMB_API_PATH_PREFIX = "eap/v1";
    public static final String KEY_ERROR_CODE = "error_code";
    public static final String KEY_RESULT = "result";
    public static final String KEY_SERVER_URL = "serverUrl";
    public static final String KEY_DEVICE_TOKEN = "deviceToken";
    public static final String KEY_EXPIRES_IN = "expiresIn";
    public static final String LEAF_PATH_VALIDATE = "validate";
    public static final String KEY_DEVICE_ID = "deviceId";
    public static final String KEY_CLOUD_USER_NAME = "cloudUserName";
    public static final String KEY_DEVICE_NAME = "deviceName";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_DEVICE_MAC = "deviceMac";
    public static final String KEY_HW_ID = "hwId";
    public static final String KEY_DEVICE_MODEL = "deviceModel";
    public static final String KEY_DEVICE_HW_VER = "deviceHwVer";
    public static final String KEY_DEVICE_TYPE = "deviceType";
    public static final String KEY_FW_ID = "fwId";
    public static final String KEY_OEM_ID = "oemId";
    public static final String KEY_FW_VER = "fwVer";
    public static final String KEY_TCSP_VER = "tcspVer";
    public static final String KEY_CONTROLLER_VERSION = "controllerVersion";
    public static final int ERROR_CODE_VAL_GENERIC_ERROR = -10000;
    public static final int ERROR_CODE_VAL_REQUEST_TIMEOUT = -20002;
    public static final int ERROR_CODE_VAL_DEVICE_TOKEN_EXPIRATE = -25001;
    public static final int ERROR_CODE_VAL_DEVICE_TOKEN_INVALID = -25002;
    private String validateHost = "n-smb-api.tplinkcloud.com";
    private String regionServerUrl;
    private final String pathPrefix = "eap/v1";
    IDeviceMgmt deviceMgmt;
    private String deviceToken;
    private long expiration;

    public ApiHttpClient(IDeviceMgmt deviceMgmt) {
        this.deviceMgmt = deviceMgmt;
    }

    public ApiHttpClient(String validateHost, IDeviceMgmt deviceMgmt) {
        this.validateHost = validateHost;
        this.deviceMgmt = deviceMgmt;
    }

    public synchronized void setValidateHost(String validateHost) {
        this.deviceToken = null;
        this.expiration = 0L;
        this.validateHost = validateHost;
    }

    public synchronized void restoreValidateHost() {
        this.deviceToken = null;
        this.expiration = 0L;
        this.validateHost = DEFAULT_SMB_API_HOST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendPostRequest(String leafPath, JSONObject request) throws IOException {
        boolean deviceTokenNeedRefresh = false;
        if (leafPath == null || request == null) {
            logger.error("Invalid parameter.");
            return null;
        }
        boolean isValidateRequest = leafPath.equals(LEAF_PATH_VALIDATE);
        JSONObject response = null;
        ApiHttpClient apiHttpClient = this;
        synchronized (apiHttpClient) {
            if (!isValidateRequest) {
                if (this.deviceToken != null) {
                    if (this.expiration <= System.currentTimeMillis() / 1000L) {
                        deviceTokenNeedRefresh = true;
                    }
                } else {
                    deviceTokenNeedRefresh = true;
                }
            } else {
                deviceTokenNeedRefresh = true;
            }
            if (deviceTokenNeedRefresh) {
                logger.debug("Ready to refresh deviceToken.");
                response = this.sendPostRequest(LEAF_PATH_VALIDATE, null, this.buildValidateRequest());
                if (response.has(KEY_ERROR_CODE) && response.getInt(KEY_ERROR_CODE) == 0) {
                    if (response.has(KEY_RESULT)) {
                        JSONObject result = response.getJSONObject(KEY_RESULT);
                        String deviceToken = result.getString(KEY_DEVICE_TOKEN);
                        long expiresIn = result.getLong(KEY_EXPIRES_IN);
                        this.deviceToken = StringUtils.isBlank((String)deviceToken) ? this.deviceToken : deviceToken;
                        this.expiration = System.currentTimeMillis() / 1000L + expiresIn / 2L;
                    }
                } else {
                    logger.warn("Failed to validate device.");
                    return response;
                }
            }
        }
        if (!isValidateRequest && (response = this.sendPostRequest(leafPath, this.deviceToken, request)).has(KEY_ERROR_CODE) && (response.getInt(KEY_ERROR_CODE) == -25001 || response.getInt(KEY_ERROR_CODE) == -25002)) {
            logger.warn("Device token is expired or invalid, so clear device token.");
            apiHttpClient = this;
            synchronized (apiHttpClient) {
                this.deviceToken = null;
                this.expiration = 0L;
                this.validateHost = DEFAULT_SMB_API_HOST;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("validateHost is {}, regionServerUrl is {}.", (Object)this.validateHost, (Object)this.regionServerUrl);
            if (LogCenter.getLogAll()) {
                logger.debug("deviceToken is {}, expiration is {}.", (Object)this.deviceToken, (Object)this.expiration);
            }
        }
        return response;
    }

    public JSONObject sendPostRequest(String leafPath, String deviceToken, JSONObject request) throws IOException {
        return this.sendPostRequest(leafPath, deviceToken, request, 35, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendPostRequest(String leafPath, String deviceToken, JSONObject request, int connTimeout, int readTimeout) throws IOException {
        if (request == null || connTimeout <= 0 || readTimeout <= 0) {
            logger.error("Invalid parameter.");
            return null;
        }
        boolean isValidateRequest = leafPath.equals(LEAF_PATH_VALIDATE);
        if (!isValidateRequest && this.regionServerUrl == null) {
            logger.warn("regionHost(provides common web service) is null, please make sures that 'validate' request gets successful response before.");
            return null;
        }
        String url = this.buildURLWithDevInfo(leafPath, deviceToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject response = this.sendPostRequest(url, headers, request, connTimeout, readTimeout);
        if (isValidateRequest && response != null) {
            ApiHttpClient apiHttpClient = this;
            synchronized (apiHttpClient) {
                if (response.has(KEY_ERROR_CODE) && response.getInt(KEY_ERROR_CODE) == 0 && response.has(KEY_RESULT)) {
                    JSONObject result = response.getJSONObject(KEY_RESULT);
                    String localHost = result.getString(KEY_SERVER_URL);
                    this.regionServerUrl = localHost != null ? localHost : this.regionServerUrl;
                }
            }
        }
        return response;
    }

    private JSONObject sendPostRequest(String url, Map<String, String> headers, JSONObject request, int connTimeout, int readTimeout) throws IOException {
        JSONObject response = null;
        if (url == null || request == null) {
            logger.error("Invalid parameter.");
            return null;
        }
        String responseStr = this.sendPostRequest(url, headers, request.toString(), connTimeout, readTimeout);
        if (responseStr != null) {
            response = JSONObject.fromObject((Object)responseStr);
        }
        if (response == null) {
            response = new JSONObject();
            response.put((Object)KEY_ERROR_CODE, (Object)-10000);
        }
        return response;
    }

    private JSONObject buildValidateRequest() {
        JSONObject request = new JSONObject();
        DeviceInfo devInfo = this.deviceMgmt.getDeviceInfo();
        if (devInfo == null || !devInfo.validateLegality()) {
            logger.error("Device information from deviceMgmt is illegal.");
            return request;
        }
        request.put((Object)KEY_DEVICE_ID, (Object)devInfo.getDeviceId());
        request.put((Object)KEY_CLOUD_USER_NAME, (Object)devInfo.getCloudUserName());
        request.put((Object)KEY_DEVICE_NAME, (Object)devInfo.getDeviceName());
        request.put((Object)KEY_ALIAS, (Object)devInfo.getAlias());
        request.put((Object)KEY_DEVICE_MAC, (Object)devInfo.getDeviceMac());
        request.put((Object)KEY_HW_ID, (Object)devInfo.getHwId());
        request.put((Object)KEY_DEVICE_MODEL, (Object)devInfo.getDeviceModel());
        request.put((Object)KEY_DEVICE_HW_VER, (Object)devInfo.getDeviceHwVer());
        request.put((Object)KEY_DEVICE_TYPE, (Object)devInfo.getDeviceType());
        request.put((Object)KEY_FW_ID, (Object)devInfo.getFwId());
        request.put((Object)KEY_OEM_ID, (Object)devInfo.getOemId());
        request.put((Object)KEY_FW_VER, (Object)devInfo.getFwVer());
        request.put((Object)KEY_TCSP_VER, (Object)"1.2");
        request.put((Object)KEY_CONTROLLER_VERSION, (Object)devInfo.getControllerVersion());
        return request;
    }

    private String buildURLWithDevInfo(String leafPath, String deviceToken) {
        String urlSegment;
        boolean isValidateRequest = leafPath.equals(LEAF_PATH_VALIDATE);
        DeviceInfo devInfo = this.deviceMgmt.getDeviceInfo();
        StringBuilder url = new StringBuilder();
        String string = urlSegment = isValidateRequest ? this.validateHost : this.regionServerUrl;
        if (urlSegment.startsWith("https:")) {
            url.append(urlSegment);
        } else {
            url.append("https://");
            url.append(urlSegment);
        }
        url.append("/");
        url.append(DEFAULT_SMB_API_PATH_PREFIX);
        url.append("/");
        url.append(leafPath);
        url.append("?");
        if (deviceToken != null) {
            this.appendURLParameter(url, KEY_DEVICE_TOKEN, deviceToken, false);
        }
        this.appendURLParameter(url, KEY_DEVICE_ID, devInfo.getDeviceId(), false);
        this.appendURLParameter(url, "user", devInfo.getCloudUserName(), false);
        this.appendURLParameter(url, "model", devInfo.getDeviceModel(), false);
        this.appendURLParameter(url, "hwVer", devInfo.getDeviceHwVer(), false);
        this.appendURLParameter(url, KEY_HW_ID, devInfo.getHwId(), false);
        this.appendURLParameter(url, KEY_OEM_ID, devInfo.getOemId(), false);
        this.appendURLParameter(url, KEY_FW_VER, devInfo.getFwVer(), false);
        this.appendURLParameter(url, KEY_DEVICE_TYPE, devInfo.getDeviceType(), true);
        return url.toString();
    }

    private void appendURLParameter(StringBuilder url, String key, String val, boolean last) {
        url.append(key);
        url.append("=");
        try {
            url.append(URLEncoder.encode(val, CHARSET_UFT8));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn(e.toString(), (Throwable)e);
            url.append(val);
        }
        if (!last) {
            url.append("&");
        }
    }
}

